<?php get_header(); ?>

<div class="definite-404-outer">
  <div class="container">
    <div class="definite-404-outer-inner">
        <div class="definite-404">
            <div class="definite-404-img">
                <img src="https://limenzy.com/hubfs/404%20error%20with%20people%20holding%20the%20numbers-amico%201.svg" alt="404 error with people holding the numbers-amico 1">
            </div>
            <div class="definite-404-contents">
                <div class="page-title">
                    <h1>Oops!</h1>
                </div>
                <div class="page-not-found">
                    <h6>PAGE NOT FOUND</h6>
                    <p>You've wandered off-limits. Let's get you back on track!</p>
                </div>
                <div class="go-home-btn">
                    <a href="">Back to Home</a>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>

<?php get_footer(); ?>


<style>
    .error404 header {
        position: relative !important;
        border-bottom: 1px solid #000000;
    }
    .definite-404-outer {
        padding: calc(max(2.9167vw, 50px)) 0 calc(max(5.6250vw, 50px)) ;
    }
    .definite-404 {
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        row-gap: 30px;
        max-width: calc(max(46.8750vw, 900px));
        margin: 0 auto;
    }
    .definite-404-img {
        width: 51.852%;
    }
    .definite-404-img img {
        width: 100%;
        display: block;
    }
    .definite-404-contents {
        width: 45.494%;
    }
    .definite-404 .page-title h1 {
        font-family: Poppins;
        font-weight: 700;
        font-size: calc(max(3.6458vw, 45px));
        line-height: calc(max(4.1667vw, 54px));
        color: #F90215;
        margin-bottom: calc(max(1.0417vw, 20px));
    }
    .definite-404 .page-not-found h6 {
        font-family: Poppins;
        font-weight: 500;
        font-size: calc(max(0.9375vw, 15px));
        line-height: calc(max(1.1458vw, 22px));
        color: #363049B3;
        margin-bottom: calc(max(0.6250vw, 12px));
    }
    .definite-404 .page-not-found p {
        font-family: Poppins;
        font-weight: 500;
        font-size: calc(max(1.4063vw, 20px));
        line-height: calc(max(2.0833vw, 28px));
        color: #1f2124;
        max-width: calc(max(20.8333vw, 300px));
    }
    .definite-404 .go-home-btn a {
        background-color: #F90215;
        color: #FFFFFF;
        border-radius: calc(max(0.5208vw, 10px));
        border: calc(max(0.0521vw, 1px)) solid #F90215;
        padding: calc(max(0.7552vw, 14px)) calc(max(2.5260vw, 32px)) calc(max(0.7552vw, 14px)) calc(max(2.5260vw, 32px));
        font-family: Cabin;
        font-weight: 600;
        font-size: calc(max(0.9375vw, 14px));
        line-height: calc(max(1.1458vw, 18px));
        transition: all .3s;
        display: inline-block;
        margin-top: calc(max(1.5625vw, 20px));
    }
    .definite-404 .go-home-btn a:hover {
        background-color: #B10311;
    }



    @media (max-width: 767px) {
        .definite-404-img {
            width: 75%;
            margin: 0 auto;
        }
        .definite-404-contents {
            width: 100%;
            text-align: center;
        }
        .definite-404 .page-not-found p {
            margin: 0 auto;
        }
    }
</style>