<?php
get_header();

if (have_posts()) :
    while (have_posts()) : the_post();
        ?>
        <div class="single-post">
            <div class="post-banner">
                <div class="container">
                    <div class="banner-contents">
                        <div class="title-dot">
                            <svg width="50" height="16" viewBox="0 0 50 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="8" cy="8" r="8" fill="#F90215"/> <circle cx="42" cy="8" r="8" fill="#F90215"/>
                            </svg>
                        </div>
                        <div class="post-title">
                            <h1><?php the_title(); ?></h1>
                        </div>
                        <div class="post-meta">
                            <div class="post-author">
                                <div class="author-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <mask id="mask0_318_9449" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="17" height="17"><rect y="0.510742" width="16.2428" height="16.2428" fill="#fff"/></mask>
                                        <g mask="url(#mask0_318_9449)"><path d="M3.38384 13.3695H4.34825L10.9638 6.75399L9.99939 5.78957L3.38384 12.4051V13.3695ZM2.03027 14.7231V11.8468L10.9638 2.93017C11.0992 2.80609 11.2486 2.71021 11.4122 2.64253C11.5757 2.57485 11.7477 2.54102 11.9282 2.54102C12.1087 2.54102 12.2835 2.57485 12.4527 2.64253C12.6219 2.71021 12.7686 2.81173 12.8926 2.94709L13.8232 3.89458C13.9586 4.01866 14.0573 4.16529 14.1193 4.33449C14.1813 4.50369 14.2124 4.67288 14.2124 4.84208C14.2124 5.02255 14.1813 5.19457 14.1193 5.35812C14.0573 5.52168 13.9586 5.67114 13.8232 5.80649L4.9066 14.7231H2.03027ZM10.4731 6.28024L9.99939 5.78957L10.9638 6.75399L10.4731 6.28024Z" fill="#fff"/></g>    
                                    </svg>
                                </div>
                                <div class="author-name">
                                    <?php the_author(); ?>
                                </div>
                            </div>
                            <div class="post-date">
                                <div class="date-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                        <mask id="mask0_318_9454" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="18" height="19"><rect x="0.0839844" y="0.772461" width="17.7194" height="17.7194" fill="#fff"/></mask>
                                        <g mask="url(#mask0_318_9454)"><path d="M3.77545 17.0152C3.36938 17.0152 3.02176 16.8706 2.73258 16.5814C2.44341 16.2923 2.29883 15.9446 2.29883 15.5386V5.20226C2.29883 4.79619 2.44341 4.44857 2.73258 4.1594C3.02176 3.87023 3.36938 3.72564 3.77545 3.72564H4.51375V2.24902H5.99037V3.72564H11.8968V2.24902H13.3735V3.72564H14.1118C14.5178 3.72564 14.8655 3.87023 15.1546 4.1594C15.4438 4.44857 15.5884 4.79619 15.5884 5.20226V15.5386C15.5884 15.9446 15.4438 16.2923 15.1546 16.5814C14.8655 16.8706 14.5178 17.0152 14.1118 17.0152H3.77545ZM3.77545 15.5386H14.1118V8.15549H3.77545V15.5386ZM3.77545 6.67887H14.1118V5.20226H3.77545V6.67887ZM8.9436 11.1087C8.73442 11.1087 8.55907 11.038 8.41756 10.8965C8.27605 10.755 8.2053 10.5796 8.2053 10.3704C8.2053 10.1612 8.27605 9.98588 8.41756 9.84437C8.55907 9.70286 8.73442 9.63211 8.9436 9.63211C9.15279 9.63211 9.32814 9.70286 9.46965 9.84437C9.61116 9.98588 9.68191 10.1612 9.68191 10.3704C9.68191 10.5796 9.61116 10.755 9.46965 10.8965C9.32814 11.038 9.15279 11.1087 8.9436 11.1087ZM5.99037 11.1087C5.78118 11.1087 5.60584 11.038 5.46433 10.8965C5.32282 10.755 5.25206 10.5796 5.25206 10.3704C5.25206 10.1612 5.32282 9.98588 5.46433 9.84437C5.60584 9.70286 5.78118 9.63211 5.99037 9.63211C6.19956 9.63211 6.37491 9.70286 6.51642 9.84437C6.65793 9.98588 6.72868 10.1612 6.72868 10.3704C6.72868 10.5796 6.65793 10.755 6.51642 10.8965C6.37491 11.038 6.19956 11.1087 5.99037 11.1087ZM11.8968 11.1087C11.6877 11.1087 11.5123 11.038 11.3708 10.8965C11.2293 10.755 11.1585 10.5796 11.1585 10.3704C11.1585 10.1612 11.2293 9.98588 11.3708 9.84437C11.5123 9.70286 11.6877 9.63211 11.8968 9.63211C12.106 9.63211 12.2814 9.70286 12.4229 9.84437C12.5644 9.98588 12.6351 10.1612 12.6351 10.3704C12.6351 10.5796 12.5644 10.755 12.4229 10.8965C12.2814 11.038 12.106 11.1087 11.8968 11.1087ZM8.9436 14.062C8.73442 14.062 8.55907 13.9912 8.41756 13.8497C8.27605 13.7082 8.2053 13.5328 8.2053 13.3237C8.2053 13.1145 8.27605 12.9391 8.41756 12.7976C8.55907 12.6561 8.73442 12.5853 8.9436 12.5853C9.15279 12.5853 9.32814 12.6561 9.46965 12.7976C9.61116 12.9391 9.68191 13.1145 9.68191 13.3237C9.68191 13.5328 9.61116 13.7082 9.46965 13.8497C9.32814 13.9912 9.15279 14.062 8.9436 14.062ZM5.99037 14.062C5.78118 14.062 5.60584 13.9912 5.46433 13.8497C5.32282 13.7082 5.25206 13.5328 5.25206 13.3237C5.25206 13.1145 5.32282 12.9391 5.46433 12.7976C5.60584 12.6561 5.78118 12.5853 5.99037 12.5853C6.19956 12.5853 6.37491 12.6561 6.51642 12.7976C6.65793 12.9391 6.72868 13.1145 6.72868 13.3237C6.72868 13.5328 6.65793 13.7082 6.51642 13.8497C6.37491 13.9912 6.19956 14.062 5.99037 14.062ZM11.8968 14.062C11.6877 14.062 11.5123 13.9912 11.3708 13.8497C11.2293 13.7082 11.1585 13.5328 11.1585 13.3237C11.1585 13.1145 11.2293 12.9391 11.3708 12.7976C11.5123 12.6561 11.6877 12.5853 11.8968 12.5853C12.106 12.5853 12.2814 12.6561 12.4229 12.7976C12.5644 12.9391 12.6351 13.1145 12.6351 13.3237C12.6351 13.5328 12.5644 13.7082 12.4229 13.8497C12.2814 13.9912 12.106 14.062 11.8968 14.062Z" fill="#fff"/></g>
                                    </svg>
                                </div>
                                <div class="date-published">
                                    <?php echo get_the_date(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="post-body">
                <div class="container">
                    <div class="post-contents">
                        <div class="post-image">
                            <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                        </div>
                        <div class="post-title">
                            <h2><?php the_title(); ?></h2>
                        </div>
                        <div class="post-content">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="recent-blogs">
                <div class="container">
                    <?php echo do_shortcode('[recent_blog_post_slider]'); ?>
                </div>
            </div>
        </div>
        <?php
    endwhile;
endif;

get_footer();
?>
